 /*******************************************************************************
 * 	Copyright 2018 Huawei Technologies Co.,Ltd.                                         
 * 	                                                                                 
 * 	Licensed under the Apache License, Version 2.0 (the "License"); you may not      
 * 	use this file except in compliance with the License. You may obtain a copy of    
 * 	the License at                                                                   
 * 	                                                                                 
 * 	    http://www.apache.org/licenses/LICENSE-2.0                                   
 * 	                                                                                 
 * 	Unless required by applicable law or agreed to in writing, software              
 * 	distributed under the License is distributed on an "AS IS" BASIS, WITHOUT        
 * 	WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the         
 * 	License for the specific language governing permissions and limitations under    
 * 	the License.                                                                     
 *******************************************************************************/
package com.huawei.openstack4j.api.nat;

import java.util.List;
import java.util.Map;

import com.huawei.openstack4j.common.RestService;
import com.huawei.openstack4j.model.common.ActionResponse;
import com.huawei.openstack4j.openstack.nat.domain.NatGateWay;
import com.huawei.openstack4j.openstack.nat.domain.NatGateWayCreate;
import com.huawei.openstack4j.openstack.nat.domain.NatGateWayUpdate;

public interface NatGateWayService extends RestService{
	
	/**
	 * list nat gate way
	 * @param natGateWayId
	 * @return
	 */
	NatGateWay get(String natGateWayId);
	/**
	 * list  nat gate ways
	 * @param filteringParams
	 * @return
	 */
	List<NatGateWay> list(Map<String, String> filteringParams);
	
	/**
	 * list  nat gate ways
	 * @param filteringParams
	 * @return
	 */
	List<NatGateWay> list();
	/**
	 * create  nat gate way
	 * @param natGateWayModel
	 * @return
	 */
	NatGateWay create(NatGateWayCreate natGateWayModel);
	/**
	 * update nat gate way
	 * @param updateModel
	 * @param natGateWayId
	 * @return
	 */
	NatGateWay update(NatGateWayUpdate updateModel , String natGateWayId);
	
	/**
	 * delete nat gate way
	 * @param natGateWayId
	 * @return
	 */
	ActionResponse delete(String natGateWayId);
	
}
