/*******************************************************************************
 * 	Copyright 2016 ContainX and OpenStack4j                                          
 * 	                                                                                 
 * 	Licensed under the Apache License, Version 2.0 (the "License"); you may not      
 * 	use this file except in compliance with the License. You may obtain a copy of    
 * 	the License at                                                                   
 * 	                                                                                 
 * 	    http://www.apache.org/licenses/LICENSE-2.0                                   
 * 	                                                                                 
 * 	Unless required by applicable law or agreed to in writing, software              
 * 	distributed under the License is distributed on an "AS IS" BASIS, WITHOUT        
 * 	WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the         
 * 	License for the specific language governing permissions and limitations under    
 * 	the License.                                                                     
 *******************************************************************************/
package com.huawei.openstack4j.model.compute;

import java.util.Date;

import com.huawei.openstack4j.model.ModelEntity;

/**
 * Represents a Fault with the Nova OpenStack service
 * 
 * @author Jeremy Unruh
 */
public interface Fault extends ModelEntity {

	/**
	 * @return the fault code
	 */
	int getCode();

	/**
	 * @return the message of the fault
	 */
	String getMessage();

	/**
	 * @return details for the fault
	 */
	String getDetails();

	/**
	 * @return the date the fault was created
	 */
	Date getCreated();
	
}
