/*******************************************************************************
 * 	Copyright 2016 ContainX and OpenStack4j                                          
 * 	                                                                                 
 * 	Licensed under the Apache License, Version 2.0 (the "License"); you may not      
 * 	use this file except in compliance with the License. You may obtain a copy of    
 * 	the License at                                                                   
 * 	                                                                                 
 * 	    http://www.apache.org/licenses/LICENSE-2.0                                   
 * 	                                                                                 
 * 	Unless required by applicable law or agreed to in writing, software              
 * 	distributed under the License is distributed on an "AS IS" BASIS, WITHOUT        
 * 	WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the         
 * 	License for the specific language governing permissions and limitations under    
 * 	the License.                                                                     
 *******************************************************************************/
package com.huawei.openstack4j.model.identity.v3;

import java.util.Map;

import com.huawei.openstack4j.common.Buildable;
import com.huawei.openstack4j.model.ModelEntity;
import com.huawei.openstack4j.model.identity.v3.builder.RoleBuilder;

/**
 * identity v3 role model class
 * 
 * @see <a href="http://developer.openstack.org/api-ref-identity-v3.html#roles-v3">API reference</a>
 */
public interface Role extends ModelEntity, Buildable<RoleBuilder> {

    /**
     * Globally unique across all domains.
     * 
     * @return the id of the role
     */
    String getId();

    /**
     * @return the name of the role
     */
    String getName();

    /**
     * @return the links of the role
     */
    Map<String, String> getLinks();

    /**
     * @return the display name of the role
     */
    String getDisplayName();

    /**
     * @return the type of the role
     */
    String getType();

    /**
     * @return the catalog of the role
     */
    String getCatalog();

    /**
     * @return the flag of the role
     */
    String getFlag();

    /**
     * @return the description of the role
     */
    String getDescription();

    /**
     * @return the policy of the role
     */
    Map<String, Object> getPolicy();
    
    /**
     * @return the domain id of the role
     */
    String getDomainId();

}
