/*******************************************************************************
 * 	Copyright 2016 ContainX and OpenStack4j                                          
 * 	                                                                                 
 * 	Licensed under the Apache License, Version 2.0 (the "License"); you may not      
 * 	use this file except in compliance with the License. You may obtain a copy of    
 * 	the License at                                                                   
 * 	                                                                                 
 * 	    http://www.apache.org/licenses/LICENSE-2.0                                   
 * 	                                                                                 
 * 	Unless required by applicable law or agreed to in writing, software              
 * 	distributed under the License is distributed on an "AS IS" BASIS, WITHOUT        
 * 	WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the         
 * 	License for the specific language governing permissions and limitations under    
 * 	the License.                                                                     
 *******************************************************************************/
package com.huawei.openstack4j.openstack.compute.domain;

import java.util.Map;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.huawei.openstack4j.model.ModelEntity;

/**
 * A Wrapper for Rest calls to set/update Meta Data
 * 
 * @author Jeremy Unruh
 */
public class MetaDataWrapper implements ModelEntity {

	private static final long serialVersionUID = 1L;

	@JsonProperty("metadata")
	Map<String, String> metadata;
	
	public MetaDataWrapper() { }
	
	private MetaDataWrapper(Map<String, String> metadata) {
		this.metadata = metadata;
	}
	
	/**
	 * Wraps the given MetaData map into the wrapper
	 *
	 * @param metadata the metadata
	 * @return the meta data wrapper
	 */
	public static MetaDataWrapper wrap(Map<String, String> metadata) {
		return new MetaDataWrapper(metadata);
	}
	
	/**
	 * @return the meta data
	 */
	public Map<String, String> getMetaData() {
		return metadata;
	}
	
}
