/*******************************************************************************
 * 	Copyright 2016 ContainX and OpenStack4j                                          
 * 	                                                                                 
 * 	Licensed under the Apache License, Version 2.0 (the "License"); you may not      
 * 	use this file except in compliance with the License. You may obtain a copy of    
 * 	the License at                                                                   
 * 	                                                                                 
 * 	    http://www.apache.org/licenses/LICENSE-2.0                                   
 * 	                                                                                 
 * 	Unless required by applicable law or agreed to in writing, software              
 * 	distributed under the License is distributed on an "AS IS" BASIS, WITHOUT        
 * 	WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the         
 * 	License for the specific language governing permissions and limitations under    
 * 	the License.                                                                     
 *******************************************************************************/
package com.huawei.openstack4j.openstack.identity.v3.internal;

import static com.google.common.base.Preconditions.checkNotNull;
import static com.huawei.openstack4j.core.transport.ClientConstants.*;

import java.util.List;

import com.huawei.openstack4j.api.identity.v3.TokenService;
import com.huawei.openstack4j.model.common.ActionResponse;
import com.huawei.openstack4j.model.identity.v3.Domain;
import com.huawei.openstack4j.model.identity.v3.Project;
import com.huawei.openstack4j.model.identity.v3.Service;
import com.huawei.openstack4j.model.identity.v3.Token;
import com.huawei.openstack4j.openstack.identity.v3.domain.KeystoneToken;
import com.huawei.openstack4j.openstack.identity.v3.domain.KeystoneDomain.Domains;
import com.huawei.openstack4j.openstack.identity.v3.domain.KeystoneProject.Projects;
import com.huawei.openstack4j.openstack.identity.v3.domain.KeystoneService.Catalog;
import com.huawei.openstack4j.openstack.internal.BaseOpenStackService;

public class TokenServiceImpl extends BaseOpenStackService implements TokenService {

    @Override
    public Token get(String tokenId) {
        checkNotNull(tokenId);
        return get(KeystoneToken.class, PATH_TOKENS).header(HEADER_X_SUBJECT_TOKEN, tokenId).execute();
    }

    @Override
    public ActionResponse check(String tokenId) {
        checkNotNull(tokenId);
        return head(ActionResponse.class, PATH_TOKENS).header(HEADER_X_SUBJECT_TOKEN, tokenId).execute();
    }

    @Override
    public ActionResponse delete(String tokenId) {
        checkNotNull(tokenId);
        return deleteWithResponse(PATH_TOKENS).header(HEADER_X_SUBJECT_TOKEN, tokenId).execute();
    }

    @Override
    public List<? extends Service> getServiceCatalog(String tokenId) {
        checkNotNull(tokenId);
        return get(Catalog.class, uri(PATH_SERVICE_CATALOGS)).execute().getList();
    }

    @Override
    public List<? extends Project> getProjectScopes(String tokenId) {
        checkNotNull(tokenId);
        return get(Projects.class, uri(PATH_PROJECT_SCOPES)).execute().getList();
    }

    @Override
    public List<? extends Domain> getDomainScopes(String tokenId) {
        checkNotNull(tokenId);
        return get(Domains.class, uri(PATH_DOMAIN_SCOPES)).execute().getList();
    }

}
