 /*******************************************************************************
 * 	Copyright 2018 Huawei Technologies Co.,Ltd.                                         
 * 	                                                                                 
 * 	Licensed under the Apache License, Version 2.0 (the "License"); you may not      
 * 	use this file except in compliance with the License. You may obtain a copy of    
 * 	the License at                                                                   
 * 	                                                                                 
 * 	    http://www.apache.org/licenses/LICENSE-2.0                                   
 * 	                                                                                 
 * 	Unless required by applicable law or agreed to in writing, software              
 * 	distributed under the License is distributed on an "AS IS" BASIS, WITHOUT        
 * 	WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the         
 * 	License for the specific language governing permissions and limitations under    
 * 	the License.                                                                     
 *******************************************************************************/
package com.huawei.openstack4j.openstack.ims.v1.domain;

import java.util.List;
import java.util.Map;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.ToString;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.huawei.openstack4j.model.ModelEntity;

@Getter
@ToString
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class ImageCreateByOBS implements ModelEntity{
	/**
	 * 
	 */
	private static final long serialVersionUID = -1134574370375036137L;
	/**
	 * 镜像名称
	 */
	private String name;
	/**
	 * 镜像描述信息。
	 */
	private String description;
	/**
	 * 操作系统类型。只能是Windows、Linux二者之一。
	 */
	@JsonProperty("os_type")
	private String osType;
	/**
	 * OBS桶中外部镜像文件地址
	 */
	@JsonProperty("image_url")
	private String imageUrl;
	/**
	 * 最小数据盘大小。取值范围40-2048GB。
	 */
	@JsonProperty("min_disk")
	private Integer minDisk;
	/**
	 * 创建加密镜像的用户主密钥
	 */
	@JsonProperty("cmk_id")
	private String cmkId;
	/**
	 * 表示当前镜像所属的企业项目
	 */
	@JsonProperty("enterprise_project_id")
	private String  enterpriseProjectId;
	/**
	 * 镜像标签列表
	 */
	private List<String> tags;
	/**
	 * 新规范的镜像标签列表
	 */
	@JsonProperty("image_tags")
	private List<Map<String,String>> imageTags;
	
	
}
