/*******************************************************************************
 * 	Copyright 2017 Huawei Technologies Co., Ltd.
 * 	                                                                                 
 * 	Licensed under the Apache License, Version 2.0 (the "License"); you may not      
 * 	use this file except in compliance with the License. You may obtain a copy of    
 * 	the License at                                                                   
 * 	                                                                                 
 * 	    http://www.apache.org/licenses/LICENSE-2.0                                   
 * 	                                                                                 
 * 	Unless required by applicable law or agreed to in writing, software              
 * 	distributed under the License is distributed on an "AS IS" BASIS, WITHOUT        
 * 	WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the         
 * 	License for the specific language governing permissions and limitations under    
 * 	the License.                                                                     
 *******************************************************************************/
package com.huawei.openstack4j.openstack.message.notification.internal;

import com.huawei.openstack4j.api.Apis;
import com.huawei.openstack4j.common.RestService;

/**
 * Notification Service Entry Point
 *
 * @author QianBiao.NG
 * @date   2017-07-17 09:35:34
 */
public class NotificationService extends BaseNotificationServices implements RestService {

	/**
	 * SMN Topic Service 
	 * 
	 * @return SMN Topic Service instance
	 */
	public TopicService topics() {
		return Apis.get(TopicService.class);
	}

	/**
	 * SMN Subscription Service 
	 * 
	 * @return SMN Subscription Service instance
	 */
	public SubscriptionService subscriptions() {
		return Apis.get(SubscriptionService.class);
	}

	/**
	 * SMN Message Template Service 
	 * 
	 * @return SMN Message Template Service instance
	 */
	public MessageTemplateService messageTemplates() {
		return Apis.get(MessageTemplateService.class);
	}
	
	/**
	 * SMN Message Service 
	 * 
	 * @return SMN Message Service instance
	 */
	public MessageService messages() {
		return Apis.get(MessageService.class);
	}

	/**
	 * SMN SMS Service 
	 * 
	 * @return SMN SMS Service instance
	 */
	public SmsService sms() {
		return Apis.get(SmsService.class);
	}

}
