/*******************************************************************************
 * 	Copyright 2016 ContainX and OpenStack4j                                          
 * 	                                                                                 
 * 	Licensed under the Apache License, Version 2.0 (the "License"); you may not      
 * 	use this file except in compliance with the License. You may obtain a copy of    
 * 	the License at                                                                   
 * 	                                                                                 
 * 	    http://www.apache.org/licenses/LICENSE-2.0                                   
 * 	                                                                                 
 * 	Unless required by applicable law or agreed to in writing, software              
 * 	distributed under the License is distributed on an "AS IS" BASIS, WITHOUT        
 * 	WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the         
 * 	License for the specific language governing permissions and limitations under    
 * 	the License.                                                                     
 *******************************************************************************/
/******************************************************************************* 	                                                                                 
 *  Huawei has modified this source file.
 * 	Copyright 2018 Huawei Technologies Co.,Ltd.                                         
 * 	                                                                                 
 * 	Licensed under the Apache License, Version 2.0 (the "License"); you may not      
 * 	use this file except in compliance with the License. You may obtain a copy of    
 * 	the License at                                                                   
 * 	                                                                                 
 * 	    http://www.apache.org/licenses/LICENSE-2.0                                   
 * 	                                                                                 
 * 	Unless required by applicable law or agreed to in writing, software              
 * 	distributed under the License is distributed on an "AS IS" BASIS, WITHOUT        
 * 	WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the         
 * 	License for the specific language governing permissions and limitations under    
 * 	the License.                             
 * *******************************************************************************/

package com.huawei.openstack4j.openstack.networking.domain.ext;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.huawei.openstack4j.model.network.ext.LbMethod;
import com.huawei.openstack4j.model.network.ext.LbPoolV2;
import com.huawei.openstack4j.model.network.ext.Protocol;
import com.huawei.openstack4j.model.network.ext.SessionPersistence;
import com.huawei.openstack4j.model.network.ext.builder.LbPoolV2Builder;
import com.huawei.openstack4j.openstack.common.ListResult;

/**
 * Lbaas V2 load balancer pool
 * @author emjburns
 */
@JsonRootName("pool")
@JsonIgnoreProperties(ignoreUnknown = true)
public class NeutronLbPoolV2 implements LbPoolV2 {

    /**
	 * 
	 */
	private static final long serialVersionUID = 8371119846157624697L;

	private String id;

    @JsonProperty("tenant_id")
    private String tenantId;

    private String name;
    
    @JsonProperty("loadbalancer_id")
    private String loadbalancerId; 

    private String description;

    private Protocol protocol;

    @JsonProperty("lb_algorithm")
    private LbMethod lbMethod;

    @JsonProperty("session_persistence")
    @JsonDeserialize(as = NeutronSessionPersistence.class)
    private SessionPersistence sessionPersistence;

    @JsonProperty("admin_state_up")
    private boolean adminStateUp = true;

    @JsonProperty("listener_id")
    private String listenerId;

    private List<ListItem> listeners;

    private List<ListItem> members;

    @JsonProperty("healthmonitor_id")
    private String healthMonitorId;

    /**
     * {@inheritDoc}
     */
    @Override
    public LbPoolV2Builder toBuilder() {
        return new LbPoolV2ConcreteBuilder(this);
    }


    /**
     * {@inheritDoc}
     */
    @Override
    public String getId(){
        return id;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String getTenantId(){
        return tenantId;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String getName(){
        return name;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String getDescription(){
        return description;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public Protocol getProtocol(){
        return protocol;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public LbMethod getLbMethod(){
        return lbMethod;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public SessionPersistence getSessionPersistence(){
        return sessionPersistence;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public boolean isAdminStateUp(){
        return adminStateUp;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public List<ListItem> getListeners(){
        return listeners;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public List<ListItem> getMembers(){
        return members;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String getHealthMonitorId(){
        return healthMonitorId;
    }

    @Override
    public String toString(){
        return MoreObjects.toStringHelper(this)
                .add("id", id)
                .add("tenantId", tenantId)
                .add("name", name)
                .add("description", description)
                .add("loadbalancerId", loadbalancerId)
                .add("protocol", protocol)
                .add("lbMethod", lbMethod)
                .add("sessionPersistence", sessionPersistence)
                .add("adminStateUp", adminStateUp)
                .add("listenerId", listenerId)
                .add("listeners", listeners)
                .add("members", members)
                .add("healthMonitorId", healthMonitorId)
                .toString();
    }

    public static class LbPoolV2ConcreteBuilder implements LbPoolV2Builder{

        private NeutronLbPoolV2 m;

        @Override
        public LbPoolV2 build() {
            return m;
        }

        public LbPoolV2ConcreteBuilder() {
            this(new NeutronLbPoolV2());
        }

        public LbPoolV2ConcreteBuilder(NeutronLbPoolV2 m) {
            this.m = m;
        }

        @Override
        public LbPoolV2Builder from(LbPoolV2 in){
            m = (NeutronLbPoolV2) in;
            return this;
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public LbPoolV2Builder tenantId(String tenantId){
            m.tenantId = tenantId;
            return this;
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public LbPoolV2Builder name(String name){
            m.name = name;
            return this;
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public LbPoolV2Builder description(String description){
            m.description = description;
            return this;
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public LbPoolV2Builder protocol(Protocol protocol){
            m.protocol = protocol;
            return this;
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public LbPoolV2Builder lbMethod(LbMethod lbMethod){
            m.lbMethod = lbMethod;
            return this;
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public LbPoolV2Builder sessionPersistence(SessionPersistence sessionPersistence){
            m.sessionPersistence = sessionPersistence;
            return this;
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public LbPoolV2Builder adminStateUp(boolean adminStateUp){
            m.adminStateUp = adminStateUp;
            return this;
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public LbPoolV2Builder listenerId(String listenerId){
            m.listenerId = listenerId;
            return this;
        }

		@Override
		public LbPoolV2Builder loadbalancerId(String loadbalancerId) {
			 m.loadbalancerId = loadbalancerId;
	         return this;
		}
    }

    public static class LbPoolsV2 extends ListResult<NeutronLbPoolV2> {
        @JsonProperty("pools")
        List<NeutronLbPoolV2> lbPools;
        /**
         * {@inheritDoc}
         */
        @Override
        protected List<NeutronLbPoolV2> value(){
            return lbPools;
        }

        @Override
        public String toString(){
            return MoreObjects.toStringHelper(this)
                    .add("lbPools", lbPools)
                    .toString();
        }
    }

    public static LbPoolV2Builder builder() {
        return new LbPoolV2ConcreteBuilder();
    }
}
