/*******************************************************************************
 * 	Copyright 2019 Huawei Technologies Co.,Ltd.
 *
 * 	Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * 	use this file except in compliance with the License. You may obtain a copy of
 * 	the License at
 *
 * 	    http://www.apache.org/licenses/LICENSE-2.0
 *
 * 	Unless required by applicable law or agreed to in writing, software
 * 	distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * 	WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * 	License for the specific language governing permissions and limitations under
 * 	the License.
 *******************************************************************************/
package com.huawei.openstack4j.openstack.vpc.v2.domain;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.ToString;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.huawei.openstack4j.model.ModelEntity;
import com.huawei.openstack4j.openstack.vpc.v2.contants.VirtualChargingMode;

@Getter
@ToString
@Builder
@NoArgsConstructor
@AllArgsConstructor
@JsonRootName("bandwidth")
public class BandwidthRemove implements ModelEntity {
    private static final long serialVersionUID = -639800833816285788L;

    /**
     * 要从共享带宽中移除的弹性公网IP信息
     */
    @JsonProperty("publicip_info")
    private List<PublicIpInfo> publicipInfo;

    /**
     * 弹性公网IP从共享带宽移除后，使用的独占带宽的计费类型。
     */
    @JsonProperty("charge_mode")
    private VirtualChargingMode chargeMode;

    /**
     * 弹性公网IP从共享带宽移除后，使用的独占带宽的带宽大小。
     */
    private Integer size;
}
