/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.connectors.jersey2;

import com.huawei.openstack4j.connectors.jersey2.ClientFactory;
import com.huawei.openstack4j.core.transport.HttpRequest;
import com.huawei.openstack4j.core.transport.internal.HttpLoggingFilter;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.client.RequestEntityProcessing;
import org.glassfish.jersey.filter.LoggingFilter;

public final class HttpCommand<R> {
    private HttpRequest<R> request;
    private Entity<?> entity;
    private Invocation.Builder invocation;
    private int retries;

    private HttpCommand(HttpRequest<R> request) {
        this.request = request;
    }

    public static <R> HttpCommand<R> create(HttpRequest<R> request) {
        HttpCommand<R> command = new HttpCommand<R>(request);
        super.initialize();
        return command;
    }

    private void initialize() {
        Client client = ClientFactory.create(this.request.getConfig());
        if (this.request.getMethod().name() == "PATCH") {
            client.property("jersey.config.client.httpUrlConnection.setMethodWorkaround", (Object)true);
        }
        WebTarget target = client.target(this.request.getEndpoint()).path(this.request.getPath());
        if (HttpLoggingFilter.isLoggingEnabled()) {
            target.register((Object)new LoggingFilter(Logger.getLogger("os"), 10000));
        }
        target = this.populateQueryParams(target, this.request);
        this.invocation = target.request(new String[]{"application/json"});
        this.populateHeaders(this.invocation, this.request);
        this.entity = this.request.getEntity() == null ? null : Entity.entity((Object)this.request.getEntity(), (String)this.request.getContentType());
    }

    public Response execute() {
        Response response = null;
        if (this.hasEntity()) {
            if (this.isInputStreamEntity()) {
                this.invocation.property("jersey.config.client.chunkedEncodingSize", (Object)1024);
                this.invocation.property("jersey.config.client.request.entity.processing", (Object)RequestEntityProcessing.CHUNKED);
            }
            response = this.invocation.method(this.request.getMethod().name(), this.getEntity());
        } else {
            response = this.request.hasJson() ? this.invocation.method(this.request.getMethod().name(), Entity.entity((Object)this.request.getJson(), (String)"application/json")) : this.invocation.method(this.request.getMethod().name());
        }
        return response;
    }

    private boolean isInputStreamEntity() {
        return this.hasEntity() && InputStream.class.isAssignableFrom(this.entity.getEntity().getClass());
    }

    public Entity<?> getEntity() {
        return this.entity;
    }

    public boolean hasEntity() {
        return this.entity != null;
    }

    public int getRetries() {
        return this.retries;
    }

    public HttpCommand<R> incrementRetriesAndReturn() {
        this.initialize();
        ++this.retries;
        return this;
    }

    public HttpRequest<R> getRequest() {
        return this.request;
    }

    private WebTarget populateQueryParams(WebTarget target, HttpRequest<R> request) {
        if (!request.hasQueryParams()) {
            return target;
        }
        for (Map.Entry entry : request.getQueryParams().entrySet()) {
            for (Object o : (List)entry.getValue()) {
                target = target.queryParam((String)entry.getKey(), new Object[]{o});
            }
        }
        return target;
    }

    private void populateHeaders(Invocation.Builder invocation, HttpRequest<R> request) {
        if (!request.hasHeaders()) {
            return;
        }
        for (Map.Entry h : request.getHeaders().entrySet()) {
            invocation.header((String)h.getKey(), h.getValue());
        }
    }
}

