/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.connectors.jersey2;

import com.huawei.openstack4j.core.transport.ExecutionOptions;
import com.huawei.openstack4j.core.transport.HttpEntityHandler;
import com.huawei.openstack4j.core.transport.HttpResponse;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.core.Response;

public class HttpResponseImpl
implements HttpResponse {
    private final Response response;

    private HttpResponseImpl(Response response) {
        this.response = response;
    }

    public static HttpResponseImpl wrap(Response response) {
        return new HttpResponseImpl(response);
    }

    public Response unwrap() {
        return this.response;
    }

    public <T> T getEntity(Class<T> returnType) {
        return this.getEntity(returnType, null);
    }

    public <T> T getEntity(Class<T> returnType, ExecutionOptions<T> options) {
        return (T)HttpEntityHandler.handle((HttpResponse)this, returnType, options);
    }

    public int getStatus() {
        return this.response.getStatus();
    }

    public String getStatusMessage() {
        return this.response.getStatusInfo().getReasonPhrase();
    }

    public InputStream getInputStream() {
        return (InputStream)this.response.getEntity();
    }

    public String header(String name) {
        return this.response.getHeaderString(name);
    }

    public Map<String, String> headers() {
        HashMap<String, String> headers = new HashMap<String, String>();
        for (String k : this.response.getHeaders().keySet()) {
            headers.put(k, this.response.getHeaderString(k));
        }
        return headers;
    }

    public <T> T readEntity(Class<T> typeToReadAs) {
        return (T)this.response.readEntity(typeToReadAs);
    }

    public void close() throws IOException {
    }

    public String getContentType() {
        return this.header("Content-Type");
    }
}

