package com.jiamai.live.api.dto.live;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 直播录像表
 * @author youqian mybatis generator 
 * 2020-05-29
 */
@Data
public class LiveRecordDto implements Serializable {
    private static final long serialVersionUID = 15907226197252175L;

    /**
     * 主键ID
     * not null default = null
     */
    private Long id;

    /**
     * 直播记录ID
     * not null default = 0
     */
    private Long liveRecordId;

    /**
     * 商户ID
     * not null default = 0
     */
    private Long merchantId;

    /**
     * 直播间ID
     * not null default = 0
     */
    private Long liveRoomId;

    /**
     * 阿里云直播steamName
     * max length = 64
     * not null default = 
     */
    private String steamName;

    /**
     * 创建时间
     * not null default = null
     */
    private Date startTime;

    /**
     * 结束时间
     * not null default = null
     */
    private Date endTime;

    /**
     * 时长(单位秒)
     * not null default = 0
     */
    private Integer duration;

    /**
     * 录像地址
     * max length = 500
     * not null default = 
     */
    private String videoUrl;

    /**
     * 视频格式,1-m3u8/2-mp4
     * not null default = 0
     */
    private Byte videoFormat;

    /**
     * 创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     * 修改时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;
}