package com.jiamai.live.api.enums;

import lombok.Getter;

import java.util.Objects;

/**
 * @author tengtuox
 * @date 2020/5/15
 * @description
 */
@Getter
public enum EnumBanComment {

    UNKNOWN((byte) -1, "未知"),
    NOT_BAN((byte) 0, "未禁言"),
    BAN((byte) 1, "已禁言"),
    ;

    private byte code;

    private String desc;

    EnumBanComment(byte code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static EnumBanComment getByCode(Byte code) {
        for (EnumBanComment e : EnumBanComment.values()) {
            if (Objects.equals(e.getCode(), code)) {
                return e;
            }
        }

        return UNKNOWN;
    }

    public static boolean isBanComment(Byte code) {
        return Objects.equals(BAN.code, code);
    }
}
