package com.jiamai.live.api.enums;

import lombok.Getter;

import java.util.Objects;

/**
 * @author tengtuox
 * @date 2020/4/22
 * @description
 */
@Getter
public enum EnumCommentType {

    UNKNOWN((byte) 0, "未知"),
    COMMENT((byte) 1, "普通评论"),
    COLLECT_GOODS((byte) 2, "收藏商品","收藏了%s"),
    FOLLOW_STORE((byte) 3, "关注店铺","关注了店铺"),
    LIKE((byte) 4, "点赞"),
    IN_ROOM((byte) 5, "进入直播间","欢迎%s进入直播间"),
    TRY((byte) 6, "试一下","请主播试一下%s号商品"),
    CONSULT((byte) 7, "询价","询价了%s"),
    ;

    private byte code;

    private String desc;

    private String content;

    EnumCommentType(byte code, String desc) {
        this.code = code;
        this.desc = desc;
        this.content = "";
    }

    EnumCommentType(byte code, String desc,String content) {
        this.code = code;
        this.desc = desc;
        this.content = content;
    }

    public static EnumCommentType getByCode(Byte code) {
        for (EnumCommentType e : EnumCommentType.values()) {
            if (Objects.equals(e.getCode(), code)) {
                return e;
            }
        }

        return UNKNOWN;
    }
}
