package com.jiamai.live.api.enums;

import lombok.Getter;

import java.util.Objects;

/**
 * @author tengtuox
 * @date 2020/5/14
 * @description 定向直播枚举
 */
@Getter
public enum EnumDirectional {

    UNKNOWN((byte) -1, "未知"),
    NOT_DIRECT((byte) 0, "非定向直播"),
    DIRECT((byte) 1, "定向直播"),
    ;

    private byte code;

    private String desc;

    EnumDirectional(byte code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static EnumDirectional getByCode(Byte code) {
        for (EnumDirectional e : EnumDirectional.values()) {
            if (Objects.equals(e.getCode(), code)) {
                return e;
            }
        }

        return UNKNOWN;
    }
}
