package com.jiamai.live.api.enums;

import lombok.Getter;

import java.util.Objects;

/**
 * @author tengtuox
 * @date 2020/5/15
 * @description
 */
@Getter
public enum EnumOperatorType {

    /**
     * 操作列表
     */
    UNKNOWN((byte) -1, "未知"),
    BAN((byte) 1, "禁言"),
    CLEAN_BAN((byte) 2, "解禁"),
    KICKOFF((byte) 3, "踢人"),
    CLEAN_KICKOFF((byte) 4, "解除踢人"),
    ;

    private final byte code;

    private final String desc;

    EnumOperatorType(byte code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static EnumOperatorType getByCode(Byte code) {
        for (EnumOperatorType e : EnumOperatorType.values()) {
            if (Objects.equals(e.getCode(), code)) {
                return e;
            }
        }

        return UNKNOWN;
    }

    public static boolean isBan(Byte code) {
        return Objects.equals(BAN.code, code);
    }

    public static boolean isClearBan(Byte code) {
        return Objects.equals(CLEAN_BAN.code, code);
    }

    public static boolean isKickOff(Byte code) {
        return Objects.equals(KICKOFF.code, code);
    }

    public static boolean isCleanKickOff(Byte code) {
        return Objects.equals(CLEAN_KICKOFF.code, code);
    }
}
