package com.jiamai.live.api.enums;

import lombok.Getter;

import java.util.Objects;

/**
 * @author tengtuox
 * @date 2020/5/11
 * @description
 */
@Getter
public enum EnumPullClarity {

    DEFAULT("", "", "原画"),
    LLD("lld", "_lld", "标清"),
    LSD("lsd", "_lsd", "标清"),
    LHD("lhd", "_lhd", "高清"),
    LUD("lud", "_lud", "超清"),
    ;

    private String code;
    private String str;
    private String desc;

    EnumPullClarity(String code, String str, String desc) {
        this.code = code;
        this.desc = desc;
        this.str = str;
    }

    public static EnumPullClarity getByCode(String code) {
        for (EnumPullClarity e : EnumPullClarity.values()) {
            if (Objects.equals(e.getCode(), code)) {
                return e;
            }
        }

        return DEFAULT;
    }
}
