package com.jiamai.live.api.enums;

/**
 * web socket 消息类型
 *
 * @author hong
 */
public enum WsMsgTypeEnum {

    SPOKE(100201, "弹幕"),
    NEW_VISITOR(100202, "有人来了"),
    IN_TIME_DATA(100203, "直播间实时数据"),
    BANNED(100204, "禁言标志"),
    SHARE(100205, "分享直播间"),
    START(100206, "直播开始"),
    NOTICE(100207, "管理员公告"),
    QUESTION(100208, "管理员提问"),
    END(100209, "直播结束"),
    BREAK(100210, "直播断开"),
    CONTINUE(100211, "直播继续"),
    ROOM_PERSON_CHANGE(100212, "直播间人数变化"),
    ROOM_COMMENT_CHANGE(100213, "直播间评论数变化"),
    ACTION(100214, "动作"),
    INTRODUCE_CHANGE(100215, "讲解商品变更"),
    TURN_CAMERA(100216, "切换摄像头"),
    ROOM_WATCH_COUNT_CHANGE(100217, "直播间人次变化"),
    KICKOFF(100218, "踢人"),
    RAFFLE(100219,"抽奖"),
    CANCEL_AFFLE(100220,"取消抽奖");
    private int type;
    private String desc;

    WsMsgTypeEnum(int type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public int getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }
}
