package com.jiamai.live.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import com.jiamai.live.api.dto.live.LiveGoodsDto;
import com.jiamai.live.api.dto.live.LiveGoodsStatisticalDto;
import com.jiamai.live.api.dto.live.LiveInfoDto;
import com.jiamai.live.api.dto.live.LiveRoomDto;
import com.jiamai.live.api.dto.live.LiveStatisticalDto;
import com.jiamai.live.api.dto.live.LiveUserFollowDto;
import com.jiamai.live.api.enums.EnumCommentType;
import com.jiamai.live.api.enums.WsMsgTypeEnum;
import com.jiamai.live.api.param.clue.LiveInfoParam;
import com.jiamai.live.api.param.clue.LiveListParam;
import com.jiamai.live.api.request.ActionRequest;
import com.jiamai.live.api.request.RoomBuyerPageRequest;
import com.jiamai.live.api.result.LiveRoomStatusResult;
import com.jiamai.live.api.result.websocket.WsResult;
import com.youqian.api.dto.raffle.RaffleDto;
import com.youqian.api.response.PageResult;
import com.youqian.auth.api.exception.BizException;

import java.util.Date;
import java.util.Collection;
import java.util.List;

/**
 * @author xiachenhang
 * @date 2020/4/21
 * @description
 */
@AdvancedFeignClient
public interface RemoteLiveService {

    /**
     * 根据商户ID组获取所有的直播状态
     * @param merchantIds 商户ID组
     * @return
     * @throws BizException
     */
    List<LiveRoomStatusResult> selectRoomStatusByMerchantIds(List<Long> merchantIds) throws BizException;

    /**
     * 根据商户ID获取直播状态
     * @param merchantId 商户ID
     * @return
     *  @throws BizException
     */
    List<LiveRoomStatusResult> selectRoomStatusByMerchantId(Long merchantId) throws BizException;

    /**
     * 直播间详情
     *
     * @return PageResult<LiveRoomDto>
     * @throws BizException BizException
     */
    PageResult<LiveRoomDto> buyerPageList(RoomBuyerPageRequest request) throws BizException;

    /**
     * 定时任务:推送提醒
     * 主播开播前15分钟推,主播提前开播推
     *  @throws BizException
     */
    void LiveReport() throws BizException;

    /**
     * 发送动作
     * @param request 动作:关注，询价，收藏
     * @param enumComment 直播间动态
     * @throws BizException
     */
    void sendAction(ActionRequest request, EnumCommentType enumComment) throws BizException;

    /**
     * 根据LiveRoomId查房间信息
     * @param roomId 房间号ID
     * @return
     * @throws BizException
     */
    LiveRoomDto selectByLiveRoomId(Long roomId) throws BizException;

    /**
     * 根据LiveRoomId组查房间信息
     * @param roomIds 房间号ID
     * @return
     * @throws BizException
     */
    List<LiveRoomDto> selectByLiveRoomIds(List<Long> roomIds) throws BizException;

    /**
     * 定时任务:实时统计开播直播间的用户人次
     */
    void liveUserCountJob();

    /**
     * 查询直播间列表
     * @param liveListParam 直播列表参数
     * @return
     */
    List<LiveRoomDto> selectLiveRoomList(LiveListParam liveListParam);

    /**
     * 查询直播间统计
     * @param liveListParam 直播列表参数
     * @return
     */
    Integer countRoomListTotal(LiveListParam liveListParam);

    List<LiveGoodsDto> selectLiveGoods(Long liveRoomId);

    /**
     * 根据直播房间号查人均观看数据
     */
    LiveStatisticalDto getStatistical(Long liveRoomId) throws BizException;

    /**
     * 根据直播间Id 查商品讲解时长和商品数
     */
    LiveGoodsStatisticalDto getGoodsStatistical(Long liveRoomId) throws BizException;

    LiveInfoDto liveInfo(LiveInfoParam liveInfoParam);

    /**
     * 直播间查询
     *
     * @param liveRoomDto liveRoomDto
     * @return PageResult<LiveRoomDto>
     * @throws BizException 异常
     */
    List<Long> selectLiveRoomId(LiveRoomDto liveRoomDto) throws BizException;


    /**
     * 广播发送抽奖消息
     * @param raffleDto 抽奖详情dto
     */
    void sendRaffleMessage(RaffleDto raffleDto);

    /**
     * 广播发送取消抽奖消息
     * @param raffleDto 抽奖详情dto
     */
    void sendCancelRaffleMessage(RaffleDto raffleDto);
    /**
     * 直播间订阅信息统计
     * @param liveRoomIds 直播间ID
     * @return 销售的订阅统计信息
     */
    List<LiveUserFollowDto> liveUserFollowList(Collection<Long> liveRoomIds);

    /**
     * 定时任务统计: 直播中数据信息
     */
    void LiveDataStatistics();

}
