package com.jiamai.live.api.request;

import com.youqian.api.request.Operator;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @author tengtuox
 * @date 2020/5/15
 * @description
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class BanCommentRequest extends Operator implements Serializable {

    @Min(1)
    @NotNull
    @ApiModelProperty(value = "直播间ID", required = true)
    private Long liveRoomId;

    @Min(1)
    @NotNull
    @ApiModelProperty(value = "被禁言的用户ID", required = true)
    private Long banUserId;

    @Max(2)
    @Min(1)
    @NotNull
    @ApiModelProperty(value = "操作类型，1-禁言/2-解禁", required = true)
    private Byte operatorType;
}
