package com.jiamai.live.api.request;

import com.youqian.api.request.Operator;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @author tengtuox
 * @date 2020/4/22
 * @description
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class CommentRequest extends Operator implements Serializable {

    /**
     * 直播间ID
     */
    @Min(1)
    @NotNull
    private Long liveRoomId;

    /**
     * 评论内容
     */
    @NotBlank
    private String comment;

    /**
     * 用户名称前端忽略
     */
    private String userName;

    /**
     * 手机号码前端忽略
     */
    private String mobile;

    /**
     * 头像前端忽略
     */
    private String avatarUrl;

}
