package com.jiamai.live.api.request;

import com.youqian.api.request.Operator;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @author xiachenhang
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class LiveRoomFollowRequest extends Operator implements Serializable {

    @Min(1)
    @NotNull
    @ApiModelProperty(value = "直播间ID", required = true)
    private Long liveRoomId;

    @ApiModelProperty(value = "订阅状态 0-取消提醒,1-提醒", required = true)
    private Integer status;

    @NotBlank
    @ApiModelProperty(value = "短链", required = true)
    private Long shotName;
}
