package com.jiamai.live.api.result.base;

import com.youqian.api.request.PageRequest;
import com.youqian.api.response.PageResult;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.apache.commons.collections4.CollectionUtils;

import java.io.Serializable;
import java.util.List;

/**
 * @author tengtuox
 * @date 2020/5/15
 * @description
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class PageResultV2<T> extends PageResult<T> implements Serializable {

    /**
     * 未处理申请数量
     */
    private Integer unDoApplyCount;


    public static <T> PageResultV2<T> create(List<T> data, Integer pageNo, Integer pageSize, Long total) {
        PageResultV2<T> pageResult = new PageResultV2<>();
        pageResult.setList(data);
        pageResult.setPageNo(pageNo);
        pageResult.setPageSize(pageSize);
        pageResult.setTotal(total);
        if (CollectionUtils.isEmpty(data)) {
            pageResult.setHasNext(false);
        } else {
            if (pageSize > data.size()) {
                pageResult.setHasNext(false);
            } else {
                pageResult.setHasNext(true);
            }
        }
        long totalPageNo = (total % pageSize == 0) ? total / pageSize : (total / pageSize + 1);
        pageResult.setTotalPageNo((int) totalPageNo);
        return pageResult;
    }

    public static <T> PageResultV2<T> create(List<T> data, PageRequest pageRequest, Long total) {
        return create(data, pageRequest.getPageNo(), pageRequest.getPageSize(), total);
    }
}
