package com.jiamai.live.api.util;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import org.apache.commons.lang.time.FastDateFormat;

import java.io.IOException;
import java.util.Calendar;
import java.util.Date;

public class DateSerializer extends JsonSerializer<Date> {

    private static final FastDateFormat fastDateFormat = FastDateFormat.getInstance("MM月dd日 上午HH:mm");

    @Override
    public void serialize(Date value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        if (value == null) {
            gen.writeString("");
            return;
        }

        String format = fastDateFormat.format(value);

        Calendar calendar = new Calendar.Builder().setInstant(value).build();
        int i = calendar.get(Calendar.HOUR_OF_DAY);
        if (i >= 12) {
            format = format.replaceAll("上午", "下午");
        }

        gen.writeString(format);
    }
}