package com.jiamai.live.api.dto.live;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 直播商品表
 * @author youqian mybatis generator 
 * 2020-04-21
 */
@Data
public class LiveGoodsDto implements Serializable {
    private static final long serialVersionUID = 15874510814008731L;

    /**
     * 主键ID
     * not null default = null
     */
    private Long id;

    /**
     * 直播商品ID
     * not null default = 0
     */
    private Long liveGoodsId;

    /**
     * 直播间ID
     * not null default = 0
     */
    private Long liveRoomId;

    /**
     * 商品直播序号
     * not null default = 0
     */
    private Integer liveOrder;

    /**
     * 商品ID
     * not null default = 0
     */
    private Long goodsId;

    /**
     * 是否删除，0-未删除，其他-已删除
     * not null default = 0
     */
    private Byte deleted;

    /**
     * 创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     * 修改时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;

    /**
     * 讲解中状态，0-非讲解中/1-讲解中
     */
    private Byte explain;

    /**
     * 是否是直播间爆品，0-否/1-是
     */
    private Byte liveHot;
}