package com.jiamai.live.api.dto.live;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 直播间
 * @author youqian mybatis generator 
 * 2020-04-21
 */
@Data
public class LiveRoomDto implements Serializable {
    private static final long serialVersionUID = 15874483138459659L;

    /**
     * 直播间ID
     * not null default = 0
     */
    private Long liveRoomId;

    /**
     * 创建人名字
     * not null default = 0
     */
    private Long createUserId;

    /**
     * 商户ID
     * not null default = 0
     */
    private Long merchantId;

    /**
     * 直播间名称
     * max length = 20
     * not null default = 
     */
    private String roomName;

    /**
     * 直播封面
     * max length = 200
     * not null default = 
     */
    private String cover;

    /**
     * 直播间小程序二维码
     * max length = 200
     * not null default = 
     */
    private String qrCode;

    /**
     * 直播状态，1-直播完成/2-未开播/3-直播中
     * not null default = 2
     */
    private Byte roomStatus;

    /**
     * 阿里云直播steamName
     * max length = 64
     * not null default = 
     */
    private String steamName;

    /**
     * 预计开播时间
     * not null default = null
     */
    private Date expectOpenTime;

    /**
     * 实际开播时间
     */
    private Date realOpenTime;

    /**
     * 实际关播时间
     */
    private Date realCloseTime;

    /**
     * 商品数量
     */
    private Integer goodsCount;

    /**
     * 订阅人数
     * not null default = 0
     */
    private Integer subscribeCount;

    /**
     * 观看人数
     * not null default = 0
     */
    private Integer watchCount;

    /**
     * 收藏次数
     * not null default = 0
     */
    private Integer collectCount;

    /**
     * 评论次数
     * not null default = 0
     */
    private Integer commentCount;

    /**
     * 询价次数
     * not null default = 0
     */
    private Integer priceAskCount;

    /**
     * 是否删除，0-未删除，其他-已删除
     * not null default = 0
     */
    private Byte deleted;

    /**
     * 创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     * 修改时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;

    /**
     * 是否定向直播0-非定向/1-定向
     * 默认0
     * EnumDirectional
     */
    private Byte directional;
    /**
     * 累计观看人次
     */
    private Integer watchPersonCount;

    /**
     * 完整录像地址URL
     */
    private String recordUrl;

    /**
     * 推流方式，1-小程序推流/2-第三方推流
     */
    private Byte pushType;

    /**
     * 点赞数量
     */
    private Integer likeCount;

    /**
     * 直播间公告
     */
    private String announcement;

    /**
     * 直播间公告背景色
     */
    private String announcementBackgroundColor;
}