package com.jiamai.live.api.dto.live;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

@Data
public class LiveStatisticalDto implements Serializable {
    /**
     * 观看人次
     */
    private Integer watchTime;
    /**
     * 观看人数
     */
    private String watchPersonTime;
    /**
     * 人均观看次数
     */
    private String averageWatchTime;
    /**
     * 用户观看直播时长
     */
    private List<UserLiveStatisticalDto> userLiveStatistical;

    /**
     * 实时最高在线人数
     */
    private Integer highestWatchPerson;
    /**
     * 人均观看时长
     */
    private String averageWatchDuration;
    /**
     * 实时观看人数
     */
    private List<RealTimeDto> realTime;
    /**
     * 直播时长
     */
    private Long liveTime;
    /**
     * 直播时长Str
     */
    private String liveTimeStr;

    /**
     * 总评论数
     */
    private String comments;
    /**
     * 人均评论数
     */
    private String averageComments;

    /**
     * 订阅人数
     */
    private Integer subscribeNumber;
}
