package com.jiamai.live.api.dto.live;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 用户直播间关注表
 * @author youqian mybatis generator 
 * 2020-04-22
 */
@Data
public class LiveUserFollowDto implements Serializable {
    private static final long serialVersionUID = 15875227370534760L;

    /**
     * 直播间ID
     * not null default = 0
     */
    private Long liveRoomId;

    /**
     * 订阅数
     */
    private Integer sub;

    /**
     * 分享人ID(销售)
     */
    private Long shareUserId;

    /**
     * 海报渠道
     */
    private Integer posterSource;

    /**
     * 卡片渠道
     */
    private Integer cardSource;

    /**
     * 推送状态:0-未推,1-已推
     * not null default = 0
     */
    private Byte push;

    /**
     * 商户ID
     * not null default = 0
     */
    private Long merchantId;
}