package com.jiamai.live.api.enums;

import lombok.Getter;

import java.util.Objects;

/**
 * @author tengtuox
 * @date 2020/5/14
 * @description
 */
@Getter
public enum EnumApplyStatus {
    UNKNOWN((byte) 0, "未知"),
    DENY((byte) 1, "已拒绝"),
    AGREE((byte) 2, "已同意"),
    WATING((byte) 3, "未处理"),
    ;

    private byte code;

    private String desc;

    EnumApplyStatus(byte code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static EnumApplyStatus getByCode(Byte code) {
        for (EnumApplyStatus e : EnumApplyStatus.values()) {
            if (Objects.equals(e.getCode(), code)) {
                return e;
            }
        }

        return UNKNOWN;
    }

    public static boolean isAgree(Byte code) {
        return Objects.equals(AGREE.getCode(), code);
    }
}
