package com.jiamai.live.api.enums;

import lombok.Getter;

import java.util.Objects;

/**
 * @author tengtuox
 * @date 2020/4/24
 * @description 直播间爆品
 */
@Getter
public enum EnumLiveHot {

    /**
     *
     */
    UNKNOWN((byte) -1, "未知"),
    NOT_LIVE_HOT((byte) 0, "不是直播间爆品"),
    IS_LIVE_HOT((byte) 1, "是直播间爆品"),
    ;

    private final byte code;

    private final String desc;

    EnumLiveHot(byte code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static EnumLiveHot getByCode(Byte code) {
        for (EnumLiveHot e : EnumLiveHot.values()) {
            if (Objects.equals(e.getCode(), code)) {
                return e;
            }
        }

        return UNKNOWN;
    }

    public static boolean isLiveHot(Byte code) {
        return Objects.equals(IS_LIVE_HOT.code, code);
    }

    public static boolean isNotLiveHot(Byte code) {
        return Objects.equals(NOT_LIVE_HOT.code, code);
    }
}
