package com.jiamai.live.api.enums;

import lombok.Getter;

import java.util.Objects;

/**
 * @author tengtuox
 * @date 2020/4/24
 * @description
 */
@Getter
public enum EnumNotify {

    UNKNOWN((byte) -1, "未知"),
    NOT_NOTIFY((byte) 0, "未通知"),
    NOTIFYED((byte) 1, "已通知"),
    NOTIFY_FAIL((byte) 2, "通知被拒收")
    ;

    private byte code;

    private String desc;

    EnumNotify(byte code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static EnumNotify getByCode(Byte code) {
        for (EnumNotify e : EnumNotify.values()) {
            if (Objects.equals(e.getCode(), code)) {
                return e;
            }
        }

        return UNKNOWN;
    }
}
