package com.jiamai.live.api.enums;

import lombok.Getter;

import java.util.Objects;

/**
 * @author tengtuox
 * @date 2020/6/30
 * @description
 */
@Getter
public enum EnumPushType {

    /**
     * 推流方式
     */
    UNKNOWN((byte) 0, "未知"),
    MINI_PUSH((byte) 1, "小程序推流"),
    THIRD_PUSH((byte) 2, "第三方推流"),
    ;

    private byte code;

    private String desc;

    EnumPushType(byte code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static EnumPushType getByCode(Byte code) {
        for (EnumPushType e : EnumPushType.values()) {
            if (Objects.equals(e.getCode(), code)) {
                return e;
            }
        }

        return UNKNOWN;
    }
}
