package com.jiamai.live.api.request;

import com.youqian.api.request.Operator;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @author tengtuox
 * @date 2020/5/19
 * @description
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class InRoomRequest extends Operator implements Serializable {

    @Min(1)
    @NotNull
    @ApiModelProperty(value = "直播间ID", required = true)
    private Long liveRoomId;

    @ApiModelProperty(value = "用户名称（前端忽略）")
    private String userName;

    @ApiModelProperty(value = "直播间分享用户ID")
    private Long shareUserId;

    @ApiModelProperty("用户头像")
    private String avatarUrl;

    @ApiModelProperty("用户手机号")
    private String mobile;

}
