package com.jiamai.live.api.request;

import com.youqian.api.request.Operator;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @author tengtuox
 * @date 2020/6/2
 * @description
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class KickOffBackRequest extends Operator implements Serializable {

    @Min(1)
    @NotNull
    @ApiModelProperty(value = "直播间ID", required = true)
    private Long liveRoomId;

    @Min(1)
    @NotNull
    @ApiModelProperty(value = "被踢用户ID", required = true)
    private Long kickUserId;

    @Max(4)
    @Min(3)
    @NotNull
    @ApiModelProperty(value = "操作类型, 3-踢人/4-解除踢人", required = true)
    private Byte operatorType;

}
