package com.jiamai.live.api.request;

import com.youqian.api.request.Operator;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

@Data
@EqualsAndHashCode(callSuper = true)
public class LiveRoomUnStartRequest extends Operator implements Serializable {

    @Min(1)
    @NotNull
    @ApiModelProperty(value = "直播间ID", required = true)
    private Long liveRoomId;


    @ApiModelProperty(value = "分享人ID", required = true)
    private Long shareUserId;

    @ApiModelProperty(value = "直播状态", required = true)
    private Byte status;

    @ApiModelProperty(value = "短链ID", required = true)
    private String shortName;

}
