package com.jiamai.live.api.request;

import com.youqian.api.request.Operator;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @author tengtuox
 * @date 2020/5/15
 * @description
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class UpdateAssistRequest extends Operator implements Serializable {

    @Min(1)
    @NotNull
    @ApiModelProperty(value = "直播间ID", required = true)
    private Long liveRoomId;

    @NotBlank
    @ApiModelProperty(value = "助手昵称", required = true)
    private String nickName;
}
