package com.jiamai.live.api.request;

import com.youqian.api.request.Operator;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @author tengtuox
 * @date 2020/6/2
 * @description
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class UpdateRecordStatusRequest extends Operator implements Serializable {

    @Min(1)
    @NotNull
    @ApiModelProperty(value = "直播间ID", required = true)
    private Long liveRoomId;

    @Max(1)
    @Min(0)
    @NotNull
    @ApiModelProperty(value = "录像状态, 1-公开，0-不公开", required = true)
    private Byte recordStatus;
}
