package com.jiamai.live.api.result.websocket;

import com.jiamai.live.api.enums.WsSubscribeTypeEnum;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.io.Serializable;

/**
 * web socket 批量推送类
 * @author hong
 */
@EqualsAndHashCode
@ToString
@Getter
public class WsBatchConsumerBean implements Serializable {

    private static final long serialVersionUID = -4505681385034245029L;

    /**
     * 推送参数数组
     */
    private Object[] subscribeUrlParams;

    /**
     * 推送内容
     */
    @Setter
    private String resultJsonStr;

    /**
     * 推送类型
     * @see WsSubscribeTypeEnum
     */
    @Setter
    private Integer sendType;

    public void setSubscribeUrlParams(Object... subscribeUrlParams) {
        this.subscribeUrlParams = subscribeUrlParams;
    }
}
