package com.jiamai.live.api.result.websocket;

import com.jiamai.live.api.enums.WsMsgTypeEnum;
import lombok.Data;

/**
 * @author hong
 */
@Data
public class WsResult<T> {

    /**
     * 推送的消息类型
     * @see com.jiamai.live.api.enums.WsMsgTypeEnum
     */
    private int msgType;

    /**
     * 响应数据
     */
    private T data;

    public static <T> WsResult<T> success(WsMsgTypeEnum msgType, T data) {
        WsResult<T> result = new WsResult<>();
        result.setMsgType(msgType.getType());
        result.setData(data);
        return result;
    }
}
