package com.jiamai.live.api.vo.websocket;

import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * Created by hong
 * time 2020/7/20.
 */
@Data
public class RedpackWsMsgVo {

    /**
     * 唯一id
     * not null default = null
     */
    private Long redpackId;

    /**
     * 创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     * 更新时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;

    /**
     * 是否删除，1=已删除，0=未删除
     * not null default = 0
     */
    private Byte deleted;

    /**
     * 发红包商户
     * not null default = 0
     */
    private Long merchantId;

    /**
     * 发红包员工
     * not null default = 0
     */
    private Long employeeId;

    /**
     * 红包金额
     * not null default = 0.0000
     */
    private BigDecimal amount;

    /**
     * 单个红包金额
     * not null default = 0.0000
     */
    private BigDecimal unitamount;

    /**
     * 红包个数
     * not null default = 0
     */
    private Integer total;

    /**
     * 红包剩余个数
     * not null default = 0
     */
    private Integer remain;

    /**
     * 发红包时间
     */
    private Date senddate;

    /**
     * 版本控制，扩展乐观锁使用
     * not null default = 0
     */
    private Integer version;

    /**
     * 是否随机金额
     * not null default = null
     */
    private Byte randomAmount;

    /**
     * 是否关注后参与
     * not null default = 0
     */
    private Byte followAfterRaffle;

    /**
     * 红包名
     * max length = 30
     * not null default = null
     */
    private String name;

    /**
     * 直播id
     * not null default = null
     */
    private Long liveId;
}
