/*
 * Decompiled with CFR 0.152.
 */
package com.jiamai.live.api.enums;

import java.util.Objects;

public enum EnumRoomStatus {
    UNKNOWN(-1, "\u672a\u77e5", "\u672a\u77e5"),
    CANCEL(0, "\u5df2\u53d6\u6d88", "\u5df2\u53d6\u6d88"),
    FINISH(1, "\u5df2\u7ed3\u675f", "\u5df2\u7ed3\u675f"),
    WAIT_OPEN(2, "\u5f85\u5f00\u64ad", "\u9884\u544a"),
    OPENING(3, "\u76f4\u64ad\u4e2d", "\u76f4\u64ad\u4e2d");

    private final byte code;
    private final String desc;
    private final String buyerDesc;

    private EnumRoomStatus(byte code, String desc, String buyerDesc) {
        this.code = code;
        this.desc = desc;
        this.buyerDesc = buyerDesc;
    }

    public static EnumRoomStatus getByCode(Byte code) {
        for (EnumRoomStatus e : EnumRoomStatus.values()) {
            if (!Objects.equals(e.getCode(), code)) continue;
            return e;
        }
        return UNKNOWN;
    }

    public static boolean isOpening(Byte code) {
        return Objects.equals(OPENING.getCode(), code);
    }

    public static boolean isFinish(Byte code) {
        return Objects.equals(FINISH.getCode(), code);
    }

    public static boolean isCancel(Byte code) {
        return Objects.equals(CANCEL.getCode(), code);
    }

    public static boolean isWaitOpen(Byte code) {
        return Objects.equals(WAIT_OPEN.getCode(), code);
    }

    public byte getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }

    public String getBuyerDesc() {
        return this.buyerDesc;
    }
}

