package com.jiamai.live.api.dto.live;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 用户直播间关注表
 * @author youqian mybatis generator 
 * 2020-04-22
 */
@Data
public class LiveUserFollowDto implements Serializable {
    private static final long serialVersionUID = 15875227370534760L;

    /**
     * 主键ID
     * not null default = null
     */
    private Long id;

    /**
     * 业务ID
     * not null default = 0
     */
    private Long liveUserFollowId;

    /**
     * 直播间ID
     * not null default = 0
     */
    private Long liveRoomId;

    /**
     * 用户ID
     * not null default = 0
     */
    private Long userId;

    /**
     * 是否删除，0-未删除，其他-已删除
     * not null default = 0
     */
    private Byte deleted;

    /**
     * 创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     * 修改时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;

    /**
     * 推送状态:0-未推,1-已推
     * not null default = 0
     */
    private Byte push;
}