package com.jiamai.live.api.enums;

import lombok.Getter;

import java.util.Objects;

/**
 * @author tengtuox
 * @date 2020/5/15
 * @description
 */
@Getter
public enum EnumBanType {

    UNKNOWN((byte) -1, "未知"),
    BAN((byte) 1, "禁言"),
    CLEAR_BAN((byte) 2, "解禁"),
    ;

    private byte code;

    private String desc;

    EnumBanType(byte code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static EnumBanType getByCode(Byte code) {
        for (EnumBanType e : EnumBanType.values()) {
            if (Objects.equals(e.getCode(), code)) {
                return e;
            }
        }

        return UNKNOWN;
    }

    public static boolean isBan(Byte code) {
        return Objects.equals(BAN.code, code);
    }

    public static boolean isClearBan(Byte code) {
        return Objects.equals(CLEAR_BAN.code, code);
    }
}
