package com.jiamai.live.api.enums;

import lombok.Getter;

import java.util.Objects;

/**
 * @author tengtuox
 * @date 2020/1/6
 * @description 是否是买家
 */
@Getter
public enum EnumRoomStatus {

    UNKNOWN((byte) -1, "未知"),
    CANCEL((byte) 0, "已取消"),
    FINISH((byte) 1, "已结束"),
    WAIT_OPEN((byte) 2, "待开播"),
    OPENING((byte) 3, "直播中"),
    ;

    private byte code;

    private String desc;

    EnumRoomStatus(byte code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static EnumRoomStatus getByCode(Byte code) {
        for (EnumRoomStatus e : EnumRoomStatus.values()) {
            if (Objects.equals(e.getCode(), code)) {
                return e;
            }
        }

        return UNKNOWN;
    }

    public static boolean isOpening(Byte code) {
        return Objects.equals(OPENING.getCode(), code);
    }

    public static boolean isFinish(Byte code) {
        return Objects.equals(FINISH.getCode(), code);
    }

    public static boolean isCancel(Byte code) {
        return Objects.equals(CANCEL.getCode(), code);
    }

    public static boolean isWaitOpen(Byte code) {
        return Objects.equals(WAIT_OPEN.getCode(), code);
    }
}
