package com.jiamai.live.api.request;

import lombok.Data;

import java.io.Serializable;

/**
 * @author tengtuox
 * @date 2020/4/20
 * @description
 */
@Data
public class PushStreamCallbackRequest implements Serializable {

    /**
     * 时间戳
     */
    private Long time;

    /**
     * 推流客户端参数
     */
    private String usrargs;

    /**
     * publish 表示推流，publish_done 表示断流
     */
    private String action;

    /**
     * 默认为自定义的推流域名，如果未绑定推流域名即为播放域名
     */
    private String app;

    /**
     * 应用名称
     */
    private String appname;

    /**
     * 流名称
     */
    private String id;

    /**
     * CDN 接受流的节点或者机器名
     */
    private String node;

    /**
     * 推流的客户端 IP
     */
    private String IP;
}
