package com.jiamai.live.api.request;

import com.youqian.api.request.Operator;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @author tengtuox
 * @date 2020/4/18
 * @description
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class UpdateRoomRequest extends Operator implements Serializable {

    @Min(1)
    @NotNull
    @ApiModelProperty(value = "直播间ID", readOnly = true)
    private Long liveRoomId;

    @ApiModelProperty(value = "直播间名称", required = true)
    private String roomName;

    @ApiModelProperty(value = "直播封面", required = true)
    private String cover;

    @ApiModelProperty(value = "预计开播时间, 格式：yyyy-MM-dd HH:mm", required = true)
    private Date expectOpenTime;

    @ApiModelProperty(value = "商品ID列表", required = true)
    private List<Long> goodsIdList;

    @ApiModelProperty("是否定向直播，0-非定向/1-定向")
    private Byte directional;

}
