package com.jiamai.live.api.result;

import com.jiamai.live.api.enums.EnumBanComment;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author tengtuox
 * @date 2020/4/27
 * @description
 */
@Data
public class CommentHisResult implements Serializable {

    /**
     * 直播评论ID
     * not null default = 0
     */
    private Long liveCommentId;

    /**
     * 直播间ID
     * not null default = 0
     */
    private Long liveRoomId;

    /**
     * 用户ID
     * not null default = 0
     */
    private Long userId;

    /**
     * 用户名称
     */
    private String userName;

    /**
     * 内容
     * max length = 100
     * not null default =
     */
    private String content;

    /**
     * 创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     * 是否禁言0-未禁言/1-已禁言
     */
    private Byte banComment = EnumBanComment.NOT_BAN.getCode();

}
