package com.jiamai.live.api.result;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author tengtuox
 * @date 2020/4/18
 * @description
 */
@Data
public class LiveRoomResult implements Serializable {

    /**
     * 直播间ID
     * not null default = 0
     */
    private Long liveRoomId;

    /**
     * 商户ID
     * not null default = 0
     */
    private Long merchantId;

    /**
     * 创建用户ID
     */
    private Long createUserId;

    /**
     * 创建人名称
     */
    private String createUserName;

    /**
     * 用户头像
     */
    private String avatarUrl;

    /**
     * 直播间名称
     */
    private String roomName;

    /**
     * 直播封面
     * max length = 200
     * not null default =
     */
    private String cover;

    /**
     * 直播间小程序二维码
     * max length = 200
     * not null default =
     */
    private String qrCode;

    /**
     * 直播间状态，1-直播完成/2-未开播/3-直播中
     */
    private Byte roomStatus;

    /**
     * 直播间状态文本
     */
    private String roomStatusText;

    /**
     * 阿里云直播steamName
     * max length = 64
     * not null default =
     */
    private String steamName;

    /**
     * 直播间列表时间文案。待开播返回预计开播时间，直播中和已结束返回实际开播时间，格式（04月23日 09:00）
     */
    @JsonFormat(pattern = "MM月dd日 HH:mm", timezone = "GMT+8")
    private Date openTimeText;

    /**
     * 预计开播时间
     * not null default = null
     */
    private Date expectOpenTime;

    /**
     * 实际开播时间
     */
    private Date realOpenTime;

    /**
     * 实际关播时间
     */
    private Date realCloseTime;

    /**
     * 订阅人数
     */
    private Integer subscribeCount = 0;

    /**
     * 观看人数
     */
    private Integer watchCount = 0;

    /**
     * 是否删除，0-未删除，其他-已删除
     * not null default = 0
     */
    private Byte deleted;

    /**
     * 创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     * 修改时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;

    /**
     * 能否进入直播间
     */
    private Boolean canEnter;

    /**
     * 是否该房间的主播
     */
    private Boolean isLiver;

    /**
     * 是否定向直播0-非定向/1-定向
     * 默认0
     */
    private Byte directional;

    /**
     * 1-是该直播间的助手
     * 0-不是该直播间的助手
     */
    private Integer assist = 0;

}
