package com.jiamai.live.api.result;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @author tengtuox
 * @date 2020/4/21
 * @description
 */
@Data
public class RoomDetailBuyerResult implements Serializable {

    /**
     * 直播间ID
     * not null default = 0
     */
    private Long liveRoomId;

    /**
     * 商户ID
     * not null default = 0
     */
    private Long merchantId;

    /**
     * 店铺名称
     */
    private String storeName;

    /**
     * 店铺Logo
     */
    private String storeLogo;

    /**
     * 是否已关注店铺
     */
    private Boolean followStore;

    /**
     * 认证状态
     */
    private Byte authStatus;

    /**
     * 主营产品
     */
    private String description;

    /**
     * 粉丝数
     */
    private Integer followCount;

    /**
     * 创建用户ID
     */
    private Long createUserId;

    /**
     * 直播间名称
     */
    private String roomName;

    /**
     * 直播封面
     * max length = 200
     * not null default =
     */
    private String cover;

    /**
     * 直播间小程序二维码
     * max length = 200
     * not null default =
     */
    private String qrCode;

    /**
     * 直播间状态，1-直播完成/2-未开播/3-直播中
     */
    private Byte roomStatus;

    /**
     * 直播间状态文本
     */
    private String roomStatusText;

    /**
     * 预计开播时间
     * not null default = null
     */
    @JsonFormat(pattern = "MM月dd日 HH:mm", timezone = "GMT+8")
    private Date expectOpenTime;

    /**
     * 直播倒计时
     */
    private String descTime;

    /**
     * 实际开播时间
     */
    private Date realOpenTime;

    /**
     * 实际关播时间
     */
    private Date realCloseTime;

    /**
     * 订阅人数
     */
    private Integer subscribeCount = 0;

    /**
     * 创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     * 修改时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;

    /**
     * 商品详情
     */
    private List<LiveGoodsResult> goodsList;

    /**
     * 是否已经订阅
     */
    private Boolean alreadySubscribe;

    /**
     * 商品数量
     */
    private Integer goodsCount = 0;

    /**
     * 模板ID
     */
    private List<String> templateIds;

    /**
     * 直播间申请模板ID
     */
    private List<String> applyTemplateIds;

    /**
     * 直播间人数
     */
    private String personCount;

    /**
     * 观看人数
     * not null default = 0
     */
    private Integer watchCount;

    /**
     * 评论次数
     * not null default = 0
     */
    private Integer commentCount;

    /**
     * 是否定向直播0-非定向/1-定向
     * 默认0
     */
    private Byte directional;

    /**
     * 申请人名称
     * max length = 100
     * not null default =
     */
    private String applyUserName;

    /**
     * 申请人企业名称
     * max length = 100
     * not null default =
     */
    private String applyEnterpriseName;

    /**
     * 申请理由
     * max length = 20
     * not null default =
     */
    private String applyReason;

    /**
     * 申请状态，3-未处理/2-已同意/1-已拒绝/0-未申请
     * not null default = 3
     */
    private Byte applyStatus = 0;

}
