package com.jiamai.live.api.result;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @author tengtuox
 * @date 2020/4/20
 * @description
 */
@Data
public class RoomDetailResult implements Serializable {

    /**
     * 直播间ID
     * not null default = 0
     */
    private Long liveRoomId;

    /**
     * 商户ID
     * not null default = 0
     */
    private Long merchantId;

    /**
     * 店铺名称
     */
    private String storeName;

    /**
     * 店铺Logo
     */
    private String storeLogo;

    /**
     * 创建用户ID
     */
    private Long createUserId;

    /**
     * 主播名称
     */
    private String userName;

    /**
     * 头像
     * max length = 500
     * not null default =
     */
    private String avatarUrl;

    /**
     * 直播间名称
     */
    private String roomName;

    /**
     * 直播封面
     * max length = 200
     * not null default =
     */
    private String cover;

    /**
     * 直播间小程序二维码
     * max length = 200
     * not null default =
     */
    private String qrCode;

    /**
     * 直播间状态，1-直播完成/2-未开播/3-直播中
     */
    private Byte roomStatus;

    /**
     * 直播间状态文本
     */
    private String roomStatusText;

    /**
     * 预计开播时间
     * not null default = null
     */
    @JsonFormat(pattern = "MM月dd日 HH:mm", timezone = "GMT+8")
    private Date expectOpenTime;

    /**
     * 实际开播时间
     */
    private Date realOpenTime;

    /**
     * 实际关播时间
     */
    private Date realCloseTime;

    /**
     * 订阅人数
     */
    private Integer subscribeCount = 0;

    /**
     * 观看人数
     */
    private Integer watchCount = 0;

    /**
     * 创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     * 修改时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;

    /**
     * 商品详情
     */
    private List<LiveGoodsResult> goodsList;

    /**
     * 商品数量
     */
    private Integer goodsCount = 0;

    /**
     * 是否展示分享直播间海报
     */
    private Boolean shareRoomPoster;

    /**
     * 是否展示邀请好友按钮
     */
    private Boolean inviteFriends;

    /**
     * 是否展示开始直播按钮
     */
    private Boolean startRoom;

    /**
     * 直播开始时长，单位秒
     */
    private Integer openSeconds;

    /**
     * 直播间人数
     */
    private String personCount;

    /**
     * 评论次数
     * not null default = 0
     */
    private Integer commentCount;

    /**
     * 清晰度
     */
    private String clarity;

    /**
     * 是否定向直播0-非定向/1-定向
     * 默认0
     */
    private Byte directional;

    /**
     * 1-是该直播间的助手
     * 0-不是该直播间的助手
     */
    private Integer assist = 0;

    /**
     * 助手昵称
     */
    private String assistNickName;
}
